 ; Ŀ
 ;   Twip - draw a twisted pair cable.                                     
 ;   Copyright 2005, 2010 by Rocket Software Ltd.                          
 ;                                                                         
 ; 
 (DEFUN C:TWIP (/ len haflen ampl pa pb dist divs lang endis pa0 pa1 pac)
  (setvar "cmdecho" 0)
  (command ".undo" "be")
  (setvar "osmode" 0)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get the scale, depending on which space we are in and other things.   
 ; 
  (if misps
      (setq dimscl (misps))
      (setq dimscl (getvar "dimscale")))
 ; Ŀ
 ;   Set the wavelength and amplitude relative to dimscale.                
 ; 
  (setq len (* 7.5 dimscl))               ; segment length
 ; (setq len (* 2 dimscl))                ; segment length - reef knots
  (setq ampl (* 2.5 dimscl))              ; segment half height
  (setq haflen (/ len 2))                 ; half of segment length
 ; Ŀ
 ;   Get the start and end points.                                         
 ; 
  (setq pa (getpoint "Start: "))
  (setq pb (getpoint pa "... and End: "))
 ; Ŀ
 ;   Calculate the number of divisions.                                    
 ; 
  (setq dist (distance pa pb))
  (setq divs (fix (/ dist len)))
 ; Ŀ
 ;   Deduce the actual start points - the waveform is constant.            
 ; 
  (setq lang (angle pa pb))                      ; line angle
  (setq endis (/ (rem dist len) 2))              ; end distance
  (setq pa0 (polar pa (+ lang (/ pi 2)) ampl))   ; offset start point
  (setq pa1 (polar pa0 lang endis))              ; offset end point
  (setq pa (polar pa lang (+ haflen endis)))     ; second main axis point
 ; Ŀ
 ;   Start the pline, if there is an end distance draw that segment.       
 ; 
  (command "pline" pa0)
  (if (not (zerop endis))
      (command pa1))
 ; Ŀ
 ;   Make the first arc half-segment.                                      
 ; 
  (command "a" "d" (* 180 (/ lang pi)) pa)
 ; Ŀ
 ;   Calculate points, feed them to the command.                           
 ; 
  (repeat (1- divs)
          (setq pa (polar pa lang len))
          (command pa))
 ; Ŀ
 ;   Make the last arc half-segment.                                       
 ; 
  (if (zerop (rem divs 2))
      (progn
           (command (setq pac (polar
                               (polar pa (+ lang (/ pi 2)) ampl) lang haflen)))
           (if (not (zerop endis))
               (command "l" (polar pb (+ lang (/ pi 2)) ampl))))
      (progn
           (command (setq pac (polar
                               (polar pa (- lang (/ pi 2)) ampl) lang haflen)))
           (if (not (zerop endis))
               (command "l" (polar pb (- lang (/ pi 2)) ampl)))))
 ; Ŀ
 ;   Finish the polyline.                                                  
 ; 
  (command "")
 ; Ŀ
 ;   And make the other half.                                              
 ; 
  (command ".mirror" (entlast) "" pa pb "n")
  (command ".undo" "end")
 (princ))